<?php
/**
 * Class WC_API_Unific_Checkout
 *
 * @package Unific
 */

/**
 * Class WC_API_Unific_Checkout
 *
 * Description of the class and its purpose.
 */
class WC_API_Unific_Checkout extends WC_API_Resource {
	/**
	 * File description.
	 *
	 * @var string $base id.
	 */
	protected $base = '/unific/checkouts';

	/**
	 * Register routes
	 *
	 * @param var $routes id.
	 */
	public function register_routes( $routes ) {
		// GET|PUT|DELETE /checkouts/<id>   // accept only digits.
		$routes[ $this->base . '/(?P<id>\d+)' ] = array(
			array( array( $this, 'get_checkout' ), WC_API_Server::READABLE ),
		);

		return $routes;
	}

	/**
	 * Get_checkouts value
	 */
	public function get_checkouts() {
		return array( 'checkout' => 'Data' );
	}

	/**
	 * Get_checkouts count value
	 */
	public function get_checkouts_count() {
		return array( 'checkout' => 'Data' );
	}

	/**
	 * Get_checkouts value
	 *
	 * @param int $id value.
	 */
	public function get_checkout( $id ) {
		global $wpdb;
		$cart_url = wc_get_cart_url();

		$ret           = array();
		$customer_data = array();
		$created       = null;
		$modified      = null;
		$cart_url      = $cart_url . '?unific_cart_hash=' . $id;

		$unific_table_name = $wpdb->prefix . 'usermeta_unific';
        // phpcs:ignore
		$results = $wpdb->get_results( $wpdb->prepare( 'SELECT meta_key,meta_value,created,modified FROM %1s WHERE entity_id = %d && entity_type = %s', $unific_table_name, $id, 'checkout' ) );

		if ( ! empty( $results ) ) {
			foreach ( $results as $result ) {
				if ( ! empty( $result->meta_key ) && ! empty( $result->meta_value ) ) {
					switch ( $result->meta_key ) {
						case 'email':
							$customer_data['email'] = $result->meta_value;
							if ( ! empty( $result->created ) ) {
								$created = $this->get_latest_date( $created, $result->created );
							}
							if ( ! empty( $result->modified ) ) {
								$modified = $this->get_latest_date( $created, $result->modified );
							}
							break;
						case 'first_name':
							$customer_data['first_name'] = stripslashes( $result->meta_value );
							if ( ! empty( $result->created ) ) {
								$created = $this->get_latest_date( $created, $result->created );
							}
							if ( ! empty( $result->modified ) ) {
								$modified = $this->get_latest_date( $created, $result->modified );
							}
							break;
						case 'last_name':
							$customer_data['last_name'] = stripslashes( $result->meta_value );
							if ( ! empty( $result->created ) ) {
								$created = $this->get_latest_date( $created, $result->created );
							}
							if ( ! empty( $result->modified ) ) {
								$modified = $this->get_latest_date( $created, $result->modified );
							}
							break;
						case 'user_id':
							$customer_data['id'] = $result->meta_value;
							break;
						case 'unific_persistent_cart':
							$meta_value = stripslashes( $result->meta_value );
							if ( @unserialize( $meta_value ) !== true && preg_match( '/^[aOs]:/', $meta_value ) ) { // phpcs:ignore
								$meta_value = preg_replace_callback(
									'/s\:(\d+)\:\"(.*?)\";/s',
									function ( $matches ) {
										return 's:' . strlen( $matches[2] ) . ':"' . $matches[2] . '";';
									},
									$meta_value
								);
							}
							$cart = unserialize( $meta_value ); // phpcs:ignore
							if ( ! empty( $cart ) ) {
								$ret['id']       = $id;
								$ret['cart_url'] = $cart_url;
								$ret['cart']     = $cart;
							}
							if ( ! empty( $result->created ) ) {
								$created = $this->get_latest_date( $created, $result->created );
							}
							if ( ! empty( $result->modified ) ) {
								$modified = $this->get_latest_date( $created, $result->modified );
							}
							break;
					}
				}
			}
		}

		if ( ! empty( $ret['cart'] ) ) {
			if ( ! empty( $created ) ) {
				$ret['created_at'] = $this->server->format_datetime( $created );
			}
			if ( ! empty( $modified ) ) {
				$ret['updated_at'] = $this->server->format_datetime( $modified );
			}
			if ( ! empty( $customer_data ) ) {
				$ret['customer'] = $customer_data;
			}
		}

		return array( 'checkout' => $ret );
	}

	/**
	 * Get_latest date
	 *
	 * @param int $current value.
	 * @param int $from_source value.
	 */
	private function get_latest_date( $current, $from_source ) {
		if ( ! empty( $from_source ) ) {
			if ( empty( $current ) ) {
				$current = $from_source;
			} elseif ( $from_source > $current ) {
					$current = $from_source;
			}
		}
		return $current;
	}
}
