<?php
/**
 * Plugin admin settings
 *
 * @package Unific
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/*
*
* Check if WooCommerce is active
*
*/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {

	/**
	 * Add Newsletter Subscription settings tab to WooCommerce settings
	 *
	 * @param string $settings_tabs value.
	 */
	function add_unific_tab( $settings_tabs ) {
		$settings_tabs['newsletter_subscription'] = __( 'Unific' );
		return $settings_tabs;
	}

	/**
	 * Add settings to the Newsletter Subscription tab
	 */
	function add_newsletter_subscription_settings_fields() {
		woocommerce_admin_fields(
			array(
				'section_title'     => array(
					'name' => __( 'Newsletter Subscription Settings' ),
					'type' => 'title',
					'desc' => '',
					'id'   => 'unific_newsletter_subscription_section_title',
				),
				'enable_newsletter' => array(
					'name'     => __( ' Enable Newsletter Subscription' ),
					'type'     => 'checkbox',
					'class'    => array( 'custom-checkbox-class' ), // Add your custom class here.
					'desc'     => __( ' Enable newsletter subscription checkbox on checkout page' ),
					'id'       => 'enable_newsletter',
					'default'  => 'yes',
					'desc_tip' => true,
				),
				'section_end'       => array(
					'type' => 'sectionend',
					'id'   => 'unific_newsletter_subscription_section_end',
				),
			)
		);
	}

	/**
	 * Save Newsletter Subscription settings
	 */
	function save_newsletter_subscription_settings() {
		$newsletter_enabled = isset( $_POST['enable_newsletter'] ) ? 'yes' : 'no'; // phpcs:ignore
		update_option( 'enable_newsletter', $newsletter_enabled );
	}

	/**
	 * Add settings link to the plugin on the plugins page.
	 *
	 * @param string $links value.
	 * @param string $file value.
	 */
	function custom_plugin_settings_link( $links, $file ) {
		if ( strpos( $file, 'unific.php' ) !== false ) {
			$settings_link = '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=newsletter_subscription' ) . '">Settings</a>';
			array_unshift( $links, $settings_link );
		}
		return $links;
	}

	add_action( 'woocommerce_settings_tabs_newsletter_subscription', 'add_newsletter_subscription_settings_fields' );
	add_action( 'woocommerce_update_options_newsletter_subscription', 'save_newsletter_subscription_settings' );
	add_filter( 'plugin_action_links', 'custom_plugin_settings_link', 10, 2 );
	add_filter( 'woocommerce_settings_tabs_array', 'add_unific_tab', 50 );

	/* ***************************** End here  ************************************ */
}
