<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Unific
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

$table_name = $wpdb->prefix . 'usermeta_unific';

require_once ABSPATH . 'wp-admin/includes/upgrade.php';
// phpcs:ignore
$wpdb->get_results( $wpdb->prepare( 'DROP TABLE IF EXISTS %1s', $table_name ) );

do_action( 'woocommerce_unific_uninstall_action', true );
